p = 4;
iterations = 30;
r_0 = (p - 2)./(p - 1);
%r_opt = 0.754877666246692;
%r_opt = 0.921599319633983;
%r_opt = 0.992987612282951;
y = [1];
r = r_0;

for k = 1:iterations
    r = test(r, p);
    y = [y, abs(r - r_opt)./abs(r_0 - r_opt)];
end

x = 0:iterations;
z = (0.5).^x;

semilogy(x, y, 'r','LineWidth',5);
hold on
semilogy(x, z, 'b','LineWidth',5);
set(gcf,'position',[0,0,600,500])
set(gca,'FontSize', 20, 'fontweight','bold')
legend({'$\frac{|r_k - r_*|}{|r_0 - r_*|}$', '$(\frac{1}{2})^{k}$'}, 'Interpreter','latex','fontsize', 60, 'location', 'southwest')
xlabel('\textbf{Number of Iteration} ${\boldmath{k}}$','Interpreter','latex','fontsize',40)
grid on
grid minor
hold off